/******************************************************************
 * SUN/DEC AF Support by Ricky Beam (cramer@catt.ncsu.edu)
 *
 ******************************************************************/


#ifdef DEC
#include "config.h"
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include "main.h"
#include "dsp.h"

static int audio;
static audio_setup saved;
static audio_setup current;

int get_dsp_device(audio_setup *requested)
{
    uint32 j;

    saved.channels = requested->channels;
    saved.bits = requested->bits;
    saved.mixspeed = requested->mixspeed;

    audio = fileno(popen("aplay -f -e pcm16", "wb"));
    if (audio < 1)
    {
	printf("Could not open audio device!\n");
	exit(1);
    }
    requested->mixspeed = 8000;
    requested->bits = 16;

    /* I don't know; what's a good size? */
    requested->buffer_size = 32768;
    current.channels = requested->channels;
    current.bits = requested->bits;
    current.mixspeed = requested->mixspeed;
    current.buffer_size = requested->buffer_size;
    return;
}

void write_dsp_device(void *buf, int size) {
        write(audio,audio_start_buffer,audio_buffer_size);
        return;
}
 
void close_dsp_device() {
    close(audio);
    return;
}
 
#endif /* ?DEC */
