/* HP-UX 9 Audiolib drivers */
/* Daniel F. Smith, 1996 (dfsmith@cr1.see.plym.ac.uk) */
/* The HP-UX Audio server is disabled by default, read the docs to
 * find out how to turn it on.
 */

#ifdef HPUX
#include <fcntl.h>
#include "config.h"
#include <audio/Alib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "main.h"
#include "dsp.h"

static Audio *audio;
static int ssocket;
static ATransID xid;
static audio_setup saved;
static audio_setup current;

int get_dsp_device(audio_setup *requested) {
  AudioAttributes attr;  
  AudioAttrMask attrmask=0;
  SStream astream;
  SSPlayParams sparams;
  int status;
  AGainEntry gainentry[2];
        
  saved.channels = requested->channels;
  saved.bits = requested->bits;
  saved.mixspeed = requested->mixspeed;

  audio=AOpenAudio(NULL,NULL);
  if (!audio) {
    perror("hpux_dsp: Could not open audio device|\n");
    exit(1);
  }

  attr=*ABestAudioAttributes(audio);
  attr.attr.sampled_attr.data_format=(requested->bits == 16)?ADFLin16:ADFLin8;
  attrmask|=ASDataFormatMask;
  attr.attr.sampled_attr.sampling_rate=requested->mixspeed;
  attrmask|=ASSamplingRateMask;
  attr.attr.sampled_attr.channels= requested->channels;
  attrmask|=ASChannelsMask;
  attr.attr.sampled_attr.interleave=(requested->channels == 2)?1:0;
  attrmask|=ASInterleaveMask;

  gainentry[0].u.o.out_ch=(requested->channels == 2)?AOCTLeft:AOCTMono;
  gainentry[0].gain=AUnityGain;
  gainentry[0].u.o.out_dst=(requested->channels == 2)?AODTLeftIntSpeaker:AODTMonoIntSpeaker;
  gainentry[1].u.o.out_ch=AOCTRight;
  gainentry[1].gain=AUnityGain;
  gainentry[1].u.o.out_dst=AODTRightIntSpeaker;

  sparams.gain_matrix.type=AGMTOutput;
  sparams.gain_matrix.num_entries=attr.attr.sampled_attr.channels;
  sparams.gain_matrix.gain_entries=gainentry;
  sparams.play_volume=AUnityGain;
  sparams.priority=APriorityNormal;
  sparams.event_mask=0;

  xid=APlaySStream(audio,attrmask,&attr,&sparams,&astream,NULL);
  ssocket=socket(AF_INET,SOCK_STREAM,0);
  if (ssocket<0) {
    perror("hpux_dsp: failed to create socket");
    exit(1);
  }
  status=connect(ssocket,(struct sockaddr *)&astream.tcp_sockaddr,
                 sizeof(struct sockaddr_in));
  if (status<0) {
    perror("hpux_dsp: failed to connect to socket");
    exit(1);
  }
  APauseAudio(audio,xid,NULL,NULL);
        
  /* I don't know; what's a good size? */
  requested->buffer_size=32768;
}

void write_dsp_device(void *buf, int size) {
        static int pause=2;
        if (pause==0)
                AResumeAudio(audio,xid,NULL,NULL);
        else
                pause--;
        write(ssocket,buf,size);
}

void close_dsp_device() {
        close(ssocket);
        ASetCloseDownMode(audio,AKeepTransactions,NULL);
        ACloseAudio(audio,NULL);
}

#endif /* HPUX */
