/***************************************************************************
 *   S3m/Mod player by Daniel Marks (dmarks@ais.net)
 *   GUS support by David Jeske (jeske@uiuc.edu)
 *
 * (C) 1994,1995 By Daniel Marks and David Jeske
 *
 * While we retain the copyright to this code, this source code is FREE.
 * You may use it in any way you wish, in any product you wish. You may 
 * NOT steal the copyright for this code from us.
 *
 * We respectfully ask that you email one of us, if possible, if you
 * produce something significant with this code, or if you have any bug 
 * fixes to contribute.  We also request that you give credit where
 * credit is due if you include part of this code in a program of your own.
 *                                                 
 * Email: s3mod@uiuc.edu
 *        jeske@uiuc.edu
 *
 * See the associated README file for Thanks
 ***************************************************************************
 *
 *  linux_dsp.c - Support for the Linux DSP driver from the Voxware(C) Drivers.
 */

#ifdef LINUX
#include "config.h"
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <linux/soundcard.h>
#include <bytesex.h>
#include "main.h"
#include "dsp.h"

static int audio;
static audio_setup saved;
static audio_setup current;

int get_dsp_device(audio_setup *requested)
{
  uint32 j;

  saved.channels = requested->channels;
  saved.bits = requested->bits;
  saved.mixspeed = requested->mixspeed;

  audio=open("/dev/dsp",O_WRONLY,0);
  if (audio < 1) {
    printf("linux_dsp: Could not open audio device!\n");
    exit(1);
  }
  if (requested->channels == 2) { 
    int stereo = 1;
    if (ioctl(audio,SNDCTL_DSP_STEREO,&stereo) == -1)
      requested->channels = 1;
  }
  if (requested->bits == 16) {
    j = 16;
    if (ioctl(audio,SNDCTL_DSP_SAMPLESIZE,&j) == -1) 
      requested->bits = 8;
  }
  j = requested->mixspeed;
  if (ioctl(audio,SNDCTL_DSP_SPEED,&j) == -1) { 
    fprintf(stderr,"linux_dsp: Error setting sample speed\n");
    exit(1);
  }
  requested->mixspeed = j;
  if (ioctl(audio,SNDCTL_DSP_GETBLKSIZE, &requested->buffer_size) == -1) {
    fprintf(stderr,"linux_dsp: Unable to get audio blocksize\n");
    exit(1);
  }
  if ((requested->buffer_size < 4096) || (requested->buffer_size > 131072)) {
    fprintf(stderr,"linux_dsp: Invalid audio buffer size: %d\n",
	    requested->buffer_size);
    exit(1);
  }
  current.channels = requested->channels;
  current.bits = requested->bits;
  current.mixspeed = requested->mixspeed;
  current.buffer_size = requested->buffer_size;
  return;
}

void write_dsp_device(void *buf, int size) {
        write(audio,buf,size);
	return;
}

void close_dsp_device() {
    close(audio);
    return;
}

#endif /* ?LINUX */

