/******************************************************************
 * S G I Support by Mike Muuss (Mike@arl.mil)
 *
 ******************************************************************/

#if defined(__sgi)
#include "config.h"
#include <unistd.h>
#include <stdio.h>
#include <audio.h>
#include "main.h"
#include "dsp.h"

static ALport	sgi_port;
static ALconfig	sgi_config;
static int sampsize;

void write_dsp_device(void *buf, int size)
{
  int	nsamp;
  int	ret;

  /* need number of samples, not number of bytes */
  nsamp = size/sampsize;
  ret = ALwritesamps(sgi_port, buf, nsamp);
  if( ret != 0 )  {
    perror("ALwritesamps()");
    fprintf(stderr,"ALwritesamps(%d) failed, ret=%d\n", nsamp, ret);
    exit(1);
  }
}

static long sgi_params[] = { AL_OUTPUT_RATE, 0 };
static audio_setup saved;
static audio_setup current;

int get_dsp_device(audio_setup *requested)
{
  saved.channels = requested->channels;
  saved.bits = requested->bits;
  saved.mixspeed = requested->mixspeed;

  sgi_params[1] = requested->mixspeed;
  if( ALsetparams( AL_DEFAULT_DEVICE, sgi_params, 2 ) < 0 )  {
    perror("ALsetparams()");
    fprintf(stderr,"ALsetparams() unable to set speed %d\n", mixspeed);
  }
  sgi_config = ALnewconfig();
  if (requested->bits == 16) {
    ALsetwidth( sgi_config, AL_SAMPLE_16);   /* range -32768 to 32767. */
    sampsize = AL_SAMPLE_16;
  } else {
    ALsetwidth( sgi_config, AL_SAMPLE_8);
    sampsize = AL_SAMPLE_8;
  }
  if (requested->channels == 2) {
    ALsetchannels( sgi_config, AL_STEREO );
    sampsize *= AL_STEREO;
  } else {
    ALsetchannels( sgi_config, AL_MONO);
    sampsize *= AL_MONO;
  }
  sgi_port = ALopenport("s3m", "w", sgi_config );

  requested->buffer_size = 44100 * 4;
  current.channels = requested->channels;
  current.bits = requested->bits;
  current.mixspeed = requested->mixspeed;
  current.buffer_size = requested->buffer_size;

}

void close_dsp_device(void)
{
	static char	zeros[4];	/* one sample of zeros */
	int	left;

	ALwritesamps(sgi_port, zeros, 1);
	while( (left = ALgetfilled(sgi_port)) > 1 )  {
		sleep(1);
	}
	ALcloseport(sgi_port);
	ALfreeconfig(sgi_config);
}


#endif /* SGI */
