/******************************************************************
 * SUN/DEC AF Support by Ricky Beam (cramer@catt.ncsu.edu)
 *
 ******************************************************************/


#ifdef SUN

#include "config.h"
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <multimedia/audio_hdr.h>
#include <multimedia/audio_errno.h>
#include <multimedia/audio_device.h>
#include "main.h"
#include "dsp.h"

Audio_hdr hdr_save, hdr;
static int audio;
static audio_setup saved;
static audio_setup current;

int get_dsp_device(audio_setup *requested) 
{
  uint32 j;
  
  saved.channels = requested->channels;
  saved.bits = requested->bits;
  saved.mixspeed = requested->mixspeed;

  audio = open("/dev/audio",O_WRONLY,0);
  if (audio < 1) {
    fprintf(stderr,"sun_dsp: Could not open audio device|\n");
    exit(1);
  }
  
  /* Save the device configuration 'cause it don't reset on its own */
  audio_get_play_config(audio, &hdr_save);
  audio_get_play_config(audio, &hdr);
  
  hdr.encoding = AUDIO_ENCODING_LINEAR;
  hdr.bytes_per_unit = 2;
  if (audio_set_play_config(audio, &hdr) != AUDIO_SUCCESS)
    fprintf(stderr, "sun_dsp: unable to set sample encoding\n");
  
  if (requested->channels == 2) {  
     /* setup stereo */
      hdr.channels = 2;
      if (audio_set_play_config(audio, &hdr) != AUDIO_SUCCESS)
	fprintf(stderr, "sun_dsp: unable to setup stereo\n");
      audio_get_play_config(audio, &hdr);
      requested->channels = hdr.channels;
  }
  
  if (requested->bits == 16) {  
    /* set 16 bit? */
      j = 16;
      hdr.bytes_per_unit = 2;
      if (audio_set_play_config(audio, &hdr) != AUDIO_SUCCESS)
	fprintf(stderr, "sun_dsp: unable to setup 16 bit samples\n");
      audio_get_play_config(audio, &hdr);
      requested->bits = (hdr.bytes_per_unit==2)?16:8;
  }
  
  /* Setup playback speed */
  hdr.sample_rate = requested->mixspeed;
  if (audio_set_play_config(audio, &hdr) != AUDIO_SUCCESS)
    fprintf(stderr, "sun_dsp: unable to setup sample speed\n");
  audio_get_play_config(audio, &hdr);
  requested->mixspeed = hdr.sample_rate;
  
  /* I don't know; what's a good size? */
  requested->buffer_size = 32768;
  current.channels = requested->channels;
  current.bits = requested->bits;
  current.mixspeed = requested->mixspeed;
  current.buffer_size = requested->buffer_size;
  return 1;
}

void write_dsp_device(void *buf, int size) {
        write(audio,buf,size);
	return;
}

void close_dsp_device() {
    close(audio);
    return;
}

#endif /* SUN */
