/***************************************************************************
 *
 * (C) 1994,1995 By Daniel Marks and David Jeske
 *
 * While we retain the copyright to this code, this source code is FREE.
 * You may use it in any way you wish, in any product you wish. You may 
 * NOT steal the copyright for this code from us.
 *
 * We respectfully ask that you email one of us, if possible, if you
 * produce something significant with this code, or if you have any bug 
 * fixes to contribute.  We also request that you give credit where
 * credit is due if you include part of this code in a program of your own.
 *                                                 
 ***************************************************************************
 *
 * dsp.h - defines for the DSP support
 *
 */

#ifndef _DSP_H
#define _DSP_H 1

#include "config.h"

#ifdef DSP
typedef struct _audio_setup {
  int channels;
  int mixspeed;
  int bits;
  int buffer_size;
} audio_setup;


int get_dsp_device(audio_setup *requested);
void write_dsp_device(void *buf, int size);
void close_dsp_device(void);
#endif /* DSP */

#endif /* _DSP_H */
